﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="Soneta.Deklaracje.ZUS" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Obniżone składki zdrowotne - zestawienie</title>
		<script runat="server">
    
        public class NFZObnizenieSkladek2 {

            public class Total : IComparable {

                class Składka {
                    public decimal podstawa;
                    public decimal składka;
                    public void Add(ISkładka skł) {
                        podstawa += skł.Podstawa;
                        składka += skł.Prac + skł.Firma;
                    }
                }

                Hashtable składki = new Hashtable();
                readonly Pracownik pracownik;
                PracHistoria historia;
                decimal obliczona;
                decimal pobrana;

                public Total(Pracownik pracownik) {
                    this.pracownik = pracownik;
                }
                public Pracownik Pracownik {
                    get { return pracownik; }
                }
                public PracHistoria Historia {
                    get { return historia; }
                }
                public void Add(WypElement element) {
                    Składka skł = (Składka)składki[element.Podatki.TyUb];
                    if (skł == null) {
                        skł = new Składka();
                        składki.Add(element.Podatki.TyUb, skł);
                    }
                    skł.Add(element.Podatki.Zdrowotna);
                }
                public bool Przelicz(Date data, Percent procent) {
                    foreach (Składka skł in składki.Values) {
                        decimal podstawa = skł.podstawa;
                        obliczona += Soneta.Tools.Math.RoundCy(podstawa * procent);
                        pobrana += skł.składka;
                    }
                    if (obliczona == pobrana)
                        return false;

                    historia = pracownik[data];
                    return true;
                }
                public int DokTypId {
                    get {
                        if (historia.PESEL == "" && historia.NIP == "")
                            switch (historia.Dokument.Rodzaj) {
                                case KodRodzajuDokumentu.DowodOsobisty:
                                    return 1;
                                case KodRodzajuDokumentu.Paszport:
                                    return 2;
                            }
                        return 0;
                    }
                }
                public string DokTyp {
                    get {
                        switch (DokTypId) {
                            case 1:
                                return "D";
                            case 2:
                                return "P";
                        }
                        return "";
                    }
                }

                public string DokNumer {
                    get { return DokTypId == 0 ? "" : historia.Dokument.SeriaNumer; }
                }
                public decimal Obliczona {
                    get { return obliczona; }
                }
                public decimal Pobrana {
                    get { return pobrana; }
                }
                public decimal Różnica {
                    get { return obliczona - pobrana; }
                }
                public int CompareTo(object obj) {
                    if (obj == null)
                        return 1;
                    Total pt = obj as Total;
                    if (pt == null)
                        throw new ArgumentException();
                    return pracownik.NazwiskoImię.CompareTo(pt.Pracownik.NazwiskoImię);
                }
            }

            readonly ArrayList lista;
            readonly decimal obliczona;
            readonly decimal pobrana;

            public NFZObnizenieSkladek2(Session session, YearMonth miesiąc, int wersja) {
                PlaceModule płace = PlaceModule.GetInstance(session);
                FromTo okres = miesiąc.ToFromTo();
                Hashtable pracownicy = new Hashtable();
                SubTable wypłaty = new SubTable(płace.Wyplaty.WgData, okres);
                foreach (Wyplata w in wypłaty) {
                    try {
                        Total pt = (Total)pracownicy[w.Pracownik];
                        if (pt == null) {
                            pt = new Total(w.Pracownik);
                            pracownicy.Add(pt.Pracownik, pt);
                        }
                        foreach (WypElement e in w.Elementy)
                            pt.Add(e);
                    }
                    catch { Msg(); }
                }

                Percent procent = płace.Config.SkładkiZUS.Zdrowotna[okres.To];
                lista = new ArrayList();
                foreach (Total pt in pracownicy.Values)
                    if (pt.Przelicz(okres.To, procent)) {
                        lista.Add(pt);
                        obliczona += pt.Obliczona;
                        pobrana += pt.Pobrana;
                    }
                lista.Sort();
            }

            public ICollection Lista {
                get { return lista; }
            }

            public decimal Obliczona {
                get { return obliczona; }
            }

            public decimal Pobrana {
                get { return pobrana; }
            }

            public decimal Obniżona {
                get { return obliczona - pobrana; }
            }
        }
        
        public class PrnParams: ContextBase {
    
            public PrnParams(Context context): base(context) {
                Date date = Date.Empty;
                if (context.Contains(typeof(ActualDate)))
                    date = ((ActualDate)context[typeof(ActualDate)]).Actual;
                else
                    date = Date.Today;
                miesiąc = new YearMonth(date);
            }
    
            YearMonth miesiąc;
            public YearMonth Miesiąc {
                get { return miesiąc; }
                set { miesiąc = value; }
            }
        }
    
        PrnParams pars;
        [Context(Required=true)]
        public PrnParams Params {
            get { return pars; }
            set { pars = value; }
        }
    
    
		decimal obliczona;
		decimal pobrana;
        void OnContextLoad(Object sender, EventArgs args) {
            report = dlTitle;
            
            NFZObnizenieSkladek2 osk = new NFZObnizenieSkladek2(pars.Session, pars.Miesiąc, 1);
			obliczona = osk.Obliczona;
			pobrana = osk.Pobrana;			        
            Grid1.DataSource = new object[] {Params.Session};
            Grid2.DataSource = osk.Lista;
            Grid3.DataSource = new object[] {Params.Session};            
            stPodpis.Caption = LiczOsoba();
        }
        
        void Grid1_BeforeRow(Object sender, RowEventArgs args) {
            colRok.EditValue = pars.Miesiąc.Year;
            colMiesiac.EditValue = pars.Miesiąc.Month;
            
            CoreModule core = CoreModule.GetInstance(pars);
            Wojewodztwa w = core.Config.Firma.AdresSiedziby.Wojewodztwo;
            string[] ss = OddzialNFZ.NazwaOddziału(w).Split(' ');
            if (ss.Length>0)
				colOddzial.EditValue = ss[0];
            colTelefonOsoby.EditValue = LiczTelefon();
        }
    
        void Grid3_BeforeRow(Object sender, RowEventArgs args) {
            colObliczone.EditValue = obliczona;
            colPobrane.EditValue = pobrana;
        }
        
        string LiczTelefon() {
			DeklaracjeModule dekl = DeklaracjeModule.GetInstance(Params);
			string telefon = dekl.Config.ZUS.Ogólne.NFZTelefon;
			if (telefon=="") {
				CoreModule core = CoreModule.GetInstance(Params);
				telefon = core.Config.Firma.AdresDoKorespondencji.Telefon;
				if (telefon=="")
					telefon = core.Config.Firma.AdresSiedziby.Telefon;
			}
			return telefon;			
        }
        
        string LiczOsoba() {
			DeklaracjeModule dekl = DeklaracjeModule.GetInstance(Params);
			string osoba = dekl.Config.ZUS.Ogólne.NFZOsoba;
			if (osoba=="")
				osoba = pars.Session.Login.Operator.FullName;
			return "<font size=2>"+osoba+"</font><br><br><font size=1>..................................................<br>Data i podpis osoby uprawnionej do sporządzenia zestawienia</font>";
		}

        public static DataLabel report;

        public static void Msg() {
            string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
            string str = (string)report.EditValue;
            if (string.IsNullOrEmpty(str))
                report.EditValue = msg;
        }

		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ObniżoneSkładkiZdrowotneZestawienie" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" Landscape="True" BottomMargin="-1"
				LeftMargin="-1" RightMargin="-1" TopMargin="-1"></ea:datacontext>
			<h3 align="center">ZESTAWIENIE OBNIŻONYCH SKŁADEK NA UBEZPIECZENIE ZDROWOTNE</h3>
            <h4 align="center"><ea:datalabel id="dlTitle" runat="server" Bold="true"></ea:datalabel></h4>
			<p>
				<ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" AroundBorder="Double" RowsInRow="5"
					ShowHeader="None" RowTypeName="Soneta.Business.Session,Soneta.Business">
					<Columns>
						<ea:GridColumn ColSpan="2" Format="&lt;b&gt;&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn ColSpan="2" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Nazwa płatnika&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn ColSpan="2" BottomBorder="Single" Align="Center" DataMember="Core.Config.Firma.Pieczątka.Nazwa"></ea:GridColumn>
						<ea:GridColumn Width="24" BottomBorder="Single" Align="Center" Format="&lt;b&gt;NIP Płatnika&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Double" Align="Center" DataMember="Core.Config.Firma.Pieczątka.NIP"></ea:GridColumn>
						<ea:GridColumn Width="23" BottomBorder="Single" Align="Center" Format="&lt;b&gt;REGON Płatnika&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Double" Align="Center" DataMember="Core.Config.Firma.Pieczątka.REGON"></ea:GridColumn>
						<ea:GridColumn ColSpan="6" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Adres płatnika&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn Width="39" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Ulica&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="Core.Config.Firma.AdresSiedziby.Ulica"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" Format="&lt;b&gt;Odbiorca Zestawienia - Oddział NFZ&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Double" Align="Center" ID="colOddzial"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" Format="&lt;b&gt;Nr domu&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="Core.Config.Firma.AdresSiedziby.NrDomu"></ea:GridColumn>
						<ea:GridColumn ColSpan="3" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Telefon os. sporządzającej&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn ColSpan="3" BottomBorder="Double" Align="Center" ID="colTelefonOsoby"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" Format="&lt;b&gt;Nr lokalu&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="Core.Config.Firma.AdresSiedziby.NrLokalu"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" Format="&lt;b&gt;Kod poczt.&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="Core.Config.Firma.AdresSiedziby.KodPocztowyS"></ea:GridColumn>
						<ea:GridColumn Width="34" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Miejscowość&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="Core.Config.Firma.AdresSiedziby.Miejscowosc"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" Format="&lt;b&gt;Okres zestawienia: rok&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Double" Align="Center" ID="colRok"></ea:GridColumn>
						<ea:GridColumn Width="23" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Gmina/Dzielnica&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="Core.Config.Firma.AdresSiedziby.Gmina"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" Format="&lt;b&gt;Okres zest.: miesiąc&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Double" Align="Center" ID="colMiesiac"></ea:GridColumn>
					</Columns>
				</ea:Grid>
			</p>
			<p>
				<strong>Dane pracowników:</strong>
				<br>
				<ea:Grid id="Grid2" runat="server" AroundBorder="Double" RowsInRow="4" ShowHeader="None">
					<Columns>
						<ea:GridColumn Width="3" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Lp.&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Double" Align="Right" DataMember="#" RowSpan="3"></ea:GridColumn>
						<ea:GridColumn Width="21" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Imię&lt;/b&gt;"
							NoWrap="True"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="Historia.Imie"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" Format="&lt;b&gt;PESEL&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Double" Align="Center" DataMember="Historia.PESEL" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Width="23" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Nazwisko&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="Historia.Nazwisko"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" Format="&lt;b&gt;NIP&lt;b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Double" Align="Center" DataMember="Historia.NIP" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn ColSpan="2" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Ulica&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn ColSpan="2" BottomBorder="Single" Align="Center" DataMember="Historia.Adres.Ulica"></ea:GridColumn>
						<ea:GridColumn Width="10" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Dok.(*)&lt;/n&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Double" Align="Center" DataMember="DokTyp"></ea:GridColumn>
						<ea:GridColumn Width="29" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Seria i nr dokumentu (*)&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Double" Align="Center" DataMember="DokNumer"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" Format="&lt;b&gt;Nr domu&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="Historia.Adres.NrDomu"></ea:GridColumn>
						<ea:GridColumn ColSpan="3" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Składka obliczona&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn ColSpan="3" BottomBorder="Double" Align="Right" DataMember="Obliczona" Format="&lt;b&gt;{0:n}&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" Format="&lt;b&gt;Nr lokalu&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="Historia.Adres.NrLokalu"></ea:GridColumn>
						<ea:GridColumn Width="13" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Kod poczt.&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="Historia.Adres.KodPocztowyS"></ea:GridColumn>
						<ea:GridColumn Width="34" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Miejscowość&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" DataMember="Historia.Adres.Miejscowosc"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Center" Format="&lt;b&gt;Składka pobrana&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Double" Align="Right" DataMember="Pobrana" Format="&lt;b&gt;{0:n}&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn Width="23" BottomBorder="Single" Align="Center" Format="&lt;b&gt;Gmina/Dzielnica&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn Align="Center" DataMember="Historia.Adres.Gmina" VAlign="Top"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Double" RowSpan="2"></ea:GridColumn>
					</Columns>
				</ea:Grid>
				<ea:Grid id="Grid3" runat="server" OnBeforeRow="Grid3_BeforeRow" AroundBorder="Double" ShowHeader="None">
					<Columns>
						<ea:GridColumn Width="70" RightBorder="None" Align="Left" Format="(*) Rodzaj dowodu tożsamości: D - dow&#243;d, P - paszport.&lt;br&gt;Wypełnić tylko wtedy gdy brak numeru PESEL i NIP"></ea:GridColumn>
						<ea:GridColumn Width="16" Align="Right" Format="&lt;b&gt;&lt;font size=3&gt;RAZEM:&lt;/font&gt;&lt;/b&gt;"></ea:GridColumn>
						<ea:GridColumn Align="Right" Format="&lt;b&gt;&lt;font size=3&gt;{0:n}&lt;/font&gt;&lt;/b&gt;"
							ID="colObliczone"></ea:GridColumn>
						<ea:GridColumn Width="34" Align="Right" Format="&lt;b&gt;&lt;font size=3&gt;{0:n}&lt;/font&gt;&lt;/b&gt;"
							ID="colPobrane"></ea:GridColumn>
						<ea:GridColumn Width="23"></ea:GridColumn>
					</Columns>
				</ea:Grid>
				<cc1:ReportFooter id="ReportFooter1" runat="server" Height="126px" TheEnd="False">
					<Subtitles>
						<cc1:FooterSubtitle SubtitleType="Empty" Width="50"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="Podpis" ID="stPodpis" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:ReportFooter>
			</p>
		</form>
	</body>
</HTML>
